//
//  MCWindow.h
//  MCApplication
//
//  Created by Ali Lalani on 9/5/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCWindow : NSWindow {
	float preferredYForSheet;
	NSRect preferredRectForSheet;

	BOOL _useMCCanBecomeKeyWindow;
	BOOL _mcCanBecomeKeyWindow;

	BOOL _closeOnClick; // closes the window when the mouse is clicked anywhere inside it
	BOOL _closeOnResignFirstResponder; // closes the window when the window loses key window status
	
	NSTimer *animationTimer;
	float animationPercentDone;
	NSCalendarDate *animationStartDate;
	
	NSMutableArray *keyboardShortcuts;
}
- (void)fadeOutAndClose;
- (void)registerKeyboardShortcutWithKeys:(NSString *)keys modifierFlags:(unsigned int)mask 
								  target:(id)aTarget
								  action:(SEL)anAction;

- (float)preferredYForSheet;
- (void)setPreferredYForSheet:(float)y;

- (NSRect)preferredRectForSheet;
- (void)setPreferredRectForSheet:(NSRect)aPreferredRectForSheet;

- (BOOL)useMCCanBecomeKeyWindow;
- (void)setUseMCCanBecomeKeyWindow:(BOOL)flag;
- (BOOL)mcCanBecomeKeyWindow;
- (void)setMcCanBecomeKeyWindow:(BOOL)flag;

- (BOOL)closeOnClick;
- (void)setCloseOnClick:(BOOL)flag;

- (BOOL)closeOnResignFirstResponder;
- (void)setCloseOnResignFirstResponder:(BOOL)flag;

- (NSMutableArray *)keyboardShortcuts;
- (void)setKeyboardShortcuts:(NSMutableArray *)aKeyboardShortcuts;
@end
